//
//  $Id: AHKABPeoplePickerWindowController.m 96 2009-06-11 17:01:30Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must	reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKABPeoplePickerWindowController.h"
#import <AddressBook/AddressBookUI.h>


@implementation AHKABPeoplePickerWindowController


#pragma mark class method
+ (id)sharedWindowController
{
	static AHKABPeoplePickerWindowController *sharedWindowController;
	if (sharedWindowController == nil)
	{
		sharedWindowController = [[AHKABPeoplePickerWindowController alloc] init];
	}
	return sharedWindowController;
}

#pragma mark initialization and deallocation

- (id)init
{
	self = [self initWithWindowNibName:@"AHKABPeoplePickerWindow"];
	if (self)
	{
		[self setWindowFrameAutosaveName:@"AHKABPeoplePickerWindow"];
		// custom initialization will be written here...
	}
	return self;
}

- (void)dealloc
{
	// custom deallocation will be written here...
	[super dealloc];
}


#pragma mark IBActions
- (IBAction)clickOKButton:(id)sender
{
	[NSApp endSheet:[self window] returnCode:NSOKButton];
	[[self window] orderOut:sender];
}

- (IBAction)clickCancelButton:(id)sender
{
    [NSApp endSheet:[self window] returnCode:NSCancelButton];
	[[self window] orderOut:sender];
}

- (IBAction)clickHelpButton:(id)sender
{
	NSString *helpBookName = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleHelpBookName"];
	[[NSHelpManager sharedHelpManager] openHelpAnchor:@"ahkabhlp33" inBook:helpBookName];
}


#pragma mark accessor methods
- (NSArray *)selectedPeople
{
	return [peoplePickerView selectedRecords];
}

@end
